/*
 * Decompiled with CFR 0.152.
 */
import org.opensolaris.os.dtrace.Consumer;
import org.opensolaris.os.dtrace.ConsumerAdapter;
import org.opensolaris.os.dtrace.ConsumerEvent;
import org.opensolaris.os.dtrace.ConsumerListener;
import org.opensolaris.os.dtrace.DTraceException;
import org.opensolaris.os.dtrace.LocalConsumer;
import org.opensolaris.os.dtrace.Option;
import org.opensolaris.os.dtrace.ProbeDescription;
import org.opensolaris.os.dtrace.Program;

public class TestStateMachine {
    static Program program;

    static void exit(int status) {
        TestStateMachine.exit(status, null);
    }

    static void exit(int status, String msg) {
        if (msg != null) {
            System.out.println(msg);
        }
        System.out.flush();
        System.err.flush();
        System.exit(status);
    }

    static void printState(Consumer consumer) {
        System.out.println("open: " + consumer.isOpen());
        System.out.println("enabled: " + consumer.isEnabled());
        System.out.println("closed: " + consumer.isClosed());
    }

    static void beforeOpen(Consumer consumer) {
        System.out.println("before open");
        TestStateMachine.printState(consumer);
        try {
            consumer.compile("syscall:::entry", new String[0]);
            TestStateMachine.exit(1, "compile before open");
        }
        catch (IllegalStateException e) {
            System.out.println(e);
        }
        catch (Exception e) {
            e.printStackTrace();
            TestStateMachine.exit(1, "compile before open");
        }
        try {
            consumer.enable();
            TestStateMachine.exit(1, "enable before open");
        }
        catch (IllegalStateException e) {
            System.out.println(e);
        }
        catch (Exception e) {
            e.printStackTrace();
            TestStateMachine.exit(1, "enable before open");
        }
        try {
            consumer.getOption("bufsize");
            TestStateMachine.exit(1, "getOption before open");
        }
        catch (IllegalStateException e) {
            System.out.println(e);
        }
        catch (Exception e) {
            e.printStackTrace();
            TestStateMachine.exit(1, "getOption before open");
        }
        try {
            consumer.setOption("bufsize", Option.mb((int)1));
            TestStateMachine.exit(1, "setOption before open");
        }
        catch (IllegalStateException e) {
            System.out.println(e);
        }
        catch (Exception e) {
            e.printStackTrace();
            TestStateMachine.exit(1, "setOption before open");
        }
        try {
            consumer.unsetOption("quiet");
            TestStateMachine.exit(1, "unsetOption before open");
        }
        catch (IllegalStateException e) {
            System.out.println(e);
        }
        catch (Exception e) {
            e.printStackTrace();
            TestStateMachine.exit(1, "unsetOption before open");
        }
        try {
            consumer.createProcess("date");
            TestStateMachine.exit(1, "createProcess before open");
        }
        catch (IllegalStateException e) {
            System.out.println(e);
        }
        catch (Exception e) {
            e.printStackTrace();
            TestStateMachine.exit(1, "createProcess before open");
        }
        try {
            consumer.grabProcess(1);
            TestStateMachine.exit(1, "grabProcess before open");
        }
        catch (IllegalStateException e) {
            System.out.println(e);
        }
        catch (Exception e) {
            e.printStackTrace();
            TestStateMachine.exit(1, "grabProcess before open");
        }
        try {
            consumer.listProbes(ProbeDescription.EMPTY);
            TestStateMachine.exit(1, "listProbes before open");
        }
        catch (IllegalStateException e) {
            System.out.println(e);
        }
        catch (Exception e) {
            e.printStackTrace();
            TestStateMachine.exit(1, "listProbes before open");
        }
        try {
            consumer.getAggregate();
            TestStateMachine.exit(1, "getAggregate before open");
        }
        catch (IllegalStateException e) {
            System.out.println(e);
        }
        catch (Exception e) {
            e.printStackTrace();
            TestStateMachine.exit(1, "getAggregate before open");
        }
        try {
            consumer.getVersion();
        }
        catch (Exception e) {
            e.printStackTrace();
            TestStateMachine.exit(1, "getVersion before open");
        }
    }

    static void beforeCompile(Consumer consumer) {
        System.out.println("before compile");
        TestStateMachine.printState(consumer);
        try {
            consumer.open(new Consumer.OpenFlag[0]);
            TestStateMachine.exit(1, "open after open");
        }
        catch (IllegalStateException e) {
            System.out.println(e);
        }
        catch (Exception e) {
            e.printStackTrace();
            TestStateMachine.exit(1, "open after open");
        }
        try {
            consumer.enable();
            TestStateMachine.exit(1, "enable before compile");
        }
        catch (IllegalStateException e) {
            System.out.println(e);
        }
        catch (Exception e) {
            e.printStackTrace();
            TestStateMachine.exit(1, "enable before compile");
        }
    }

    static void beforeEnable(Consumer consumer) {
        System.out.println("before enable");
        TestStateMachine.printState(consumer);
        try {
            consumer.go();
            TestStateMachine.exit(1, "go before enable");
        }
        catch (IllegalStateException e) {
            System.out.println(e);
        }
        catch (Exception e) {
            e.printStackTrace();
            TestStateMachine.exit(1, "go before enable");
        }
    }

    static void beforeGo(Consumer consumer) {
        System.out.println("before go");
        TestStateMachine.printState(consumer);
        try {
            consumer.getAggregate();
            TestStateMachine.exit(1, "getAggregate before go");
        }
        catch (IllegalStateException e) {
            System.out.println(e);
        }
        catch (Exception e) {
            e.printStackTrace();
            TestStateMachine.exit(1, "getAggregate before go");
        }
        try {
            consumer.lookupKernelFunction(1);
            TestStateMachine.exit(1, "lookupKernelFunction before go");
        }
        catch (IllegalStateException e) {
            System.out.println(e);
        }
        catch (Exception e) {
            e.printStackTrace();
            TestStateMachine.exit(1, "lookupKernelFunction before go");
        }
        try {
            consumer.lookupUserFunction(1, 1);
            TestStateMachine.exit(1, "lookupUserFunction before go");
        }
        catch (IllegalStateException e) {
            System.out.println(e);
        }
        catch (Exception e) {
            e.printStackTrace();
            TestStateMachine.exit(1, "lookupUserFunction before go");
        }
        try {
            consumer.stop();
            TestStateMachine.exit(1, "stop before go");
        }
        catch (IllegalStateException e) {
            System.out.println(e);
        }
        catch (Exception e) {
            e.printStackTrace();
            TestStateMachine.exit(1, "stop before go");
        }
    }

    static void afterGo(Consumer consumer, Program program) {
        System.out.println("after go");
        TestStateMachine.printState(consumer);
        try {
            consumer.go();
            TestStateMachine.exit(1, "go after go");
        }
        catch (IllegalStateException e) {
            System.out.println(e);
        }
        catch (Exception e) {
            e.printStackTrace();
            TestStateMachine.exit(1, "go after go");
        }
        try {
            consumer.createProcess("date");
            TestStateMachine.exit(1, "createProcess after go");
        }
        catch (IllegalStateException e) {
            System.out.println(e);
        }
        catch (Exception e) {
            e.printStackTrace();
            TestStateMachine.exit(1, "createProcess after go");
        }
        try {
            consumer.grabProcess(1);
            TestStateMachine.exit(1, "grabProcess after go");
        }
        catch (IllegalStateException e) {
            System.out.println(e);
        }
        catch (Exception e) {
            e.printStackTrace();
            TestStateMachine.exit(1, "grabProcess after go");
        }
        try {
            consumer.listProbes(ProbeDescription.EMPTY);
            TestStateMachine.exit(1, "listProbes after go");
        }
        catch (IllegalStateException e) {
            System.out.println(e);
        }
        catch (Exception e) {
            e.printStackTrace();
            TestStateMachine.exit(1, "listProbes after go");
        }
        try {
            consumer.compile("syscall:::entry", new String[0]);
            TestStateMachine.exit(1, "compile after go");
        }
        catch (IllegalStateException e) {
            System.out.println(e);
        }
        catch (Exception e) {
            e.printStackTrace();
            TestStateMachine.exit(1, "compile after go");
        }
        try {
            consumer.enable();
            TestStateMachine.exit(1, "enable after go");
        }
        catch (IllegalStateException e) {
            System.out.println(e);
        }
        catch (Exception e) {
            e.printStackTrace();
            TestStateMachine.exit(1, "enable after go");
        }
        try {
            consumer.getAggregate();
        }
        catch (Exception e) {
            e.printStackTrace();
            TestStateMachine.exit(1, "getAggregate after go");
        }
        try {
            consumer.getProgramInfo(program);
        }
        catch (Exception e) {
            e.printStackTrace();
            TestStateMachine.exit(1, "getProgramInfo after go");
        }
        try {
            consumer.getOption("quiet");
            consumer.setOption("quiet");
            consumer.unsetOption("quiet");
        }
        catch (Exception e) {
            e.printStackTrace();
            TestStateMachine.exit(1, "get, set, unset option after go");
        }
    }

    static void afterStop(Consumer consumer, Program program) {
        System.out.println("after stop");
        TestStateMachine.printState(consumer);
        try {
            consumer.stop();
            TestStateMachine.exit(1, "stop after stop");
        }
        catch (IllegalStateException e) {
            System.out.println(e);
        }
        catch (Exception e) {
            e.printStackTrace();
            TestStateMachine.exit(1, "stop after stop");
        }
        try {
            consumer.getAggregate();
        }
        catch (Exception e) {
            e.printStackTrace();
            TestStateMachine.exit(1, "getAggregate after stop");
        }
        try {
            consumer.getProgramInfo(program);
        }
        catch (Exception e) {
            e.printStackTrace();
            TestStateMachine.exit(1, "getProgramInfo after stop");
        }
        try {
            consumer.getOption("quiet");
            consumer.setOption("quiet");
            consumer.unsetOption("quiet");
        }
        catch (Exception e) {
            e.printStackTrace();
            TestStateMachine.exit(1, "get, set, unset option after stop");
        }
    }

    static void afterClose(Consumer consumer, Program program) {
        System.out.println("after close");
        TestStateMachine.printState(consumer);
        try {
            consumer.open(new Consumer.OpenFlag[0]);
            TestStateMachine.exit(1, "open after close");
        }
        catch (IllegalStateException e) {
            System.out.println(e);
        }
        catch (Exception e) {
            e.printStackTrace();
            TestStateMachine.exit(1, "open after close");
        }
        try {
            consumer.compile("syscall:::entry", new String[0]);
            TestStateMachine.exit(1, "compile after close");
        }
        catch (IllegalStateException e) {
            System.out.println(e);
        }
        catch (Exception e) {
            e.printStackTrace();
            TestStateMachine.exit(1, "compile after close");
        }
        try {
            consumer.enable();
            TestStateMachine.exit(1, "enable after close");
        }
        catch (IllegalStateException e) {
            System.out.println(e);
        }
        catch (Exception e) {
            e.printStackTrace();
            TestStateMachine.exit(1, "enable after close");
        }
        try {
            consumer.getOption("bufsize");
            TestStateMachine.exit(1, "getOption after close");
        }
        catch (IllegalStateException e) {
            System.out.println(e);
        }
        catch (Exception e) {
            e.printStackTrace();
            TestStateMachine.exit(1, "getOption after close");
        }
        try {
            consumer.setOption("bufsize", Option.mb((int)1));
            TestStateMachine.exit(1, "setOption after close");
        }
        catch (IllegalStateException e) {
            System.out.println(e);
        }
        catch (Exception e) {
            e.printStackTrace();
            TestStateMachine.exit(1, "setOption after close");
        }
        try {
            consumer.unsetOption("quiet");
            TestStateMachine.exit(1, "unsetOption after close");
        }
        catch (IllegalStateException e) {
            System.out.println(e);
        }
        catch (Exception e) {
            e.printStackTrace();
            TestStateMachine.exit(1, "unsetOption after close");
        }
        try {
            consumer.createProcess("date");
            TestStateMachine.exit(1, "createProcess after close");
        }
        catch (IllegalStateException e) {
            System.out.println(e);
        }
        catch (Exception e) {
            e.printStackTrace();
            TestStateMachine.exit(1, "createProcess after close");
        }
        try {
            consumer.grabProcess(1);
            TestStateMachine.exit(1, "grabProcess after close");
        }
        catch (IllegalStateException e) {
            System.out.println(e);
        }
        catch (Exception e) {
            e.printStackTrace();
            TestStateMachine.exit(1, "grabProcess after close");
        }
        try {
            consumer.listProbes(ProbeDescription.EMPTY);
            TestStateMachine.exit(1, "listProbes after close");
        }
        catch (IllegalStateException e) {
            System.out.println(e);
        }
        catch (Exception e) {
            e.printStackTrace();
            TestStateMachine.exit(1, "listProbes after close");
        }
        try {
            consumer.getAggregate();
            TestStateMachine.exit(1, "getAggregate after close");
        }
        catch (IllegalStateException e) {
            System.out.println(e);
        }
        catch (Exception e) {
            e.printStackTrace();
            TestStateMachine.exit(1, "getAggregate after close");
        }
        try {
            consumer.getVersion();
        }
        catch (Exception e) {
            e.printStackTrace();
            TestStateMachine.exit(1, "getVersion after close");
        }
        try {
            consumer.go();
            TestStateMachine.exit(1, "go after close");
        }
        catch (IllegalStateException e) {
            System.out.println(e);
        }
        catch (Exception e) {
            e.printStackTrace();
            TestStateMachine.exit(1, "go after close");
        }
        try {
            consumer.lookupKernelFunction(1);
            TestStateMachine.exit(1, "lookupKernelFunction after close");
        }
        catch (IllegalStateException e) {
            System.out.println(e);
        }
        catch (Exception e) {
            e.printStackTrace();
            TestStateMachine.exit(1, "lookupKernelFunction after close");
        }
        try {
            consumer.lookupUserFunction(1, 1);
            TestStateMachine.exit(1, "lookupUserFunction after close");
        }
        catch (IllegalStateException e) {
            System.out.println(e);
        }
        catch (Exception e) {
            e.printStackTrace();
            TestStateMachine.exit(1, "lookupUserFunction after close");
        }
        try {
            consumer.stop();
            TestStateMachine.exit(1, "stop after close");
        }
        catch (IllegalStateException e) {
            System.out.println(e);
        }
        catch (Exception e) {
            e.printStackTrace();
            TestStateMachine.exit(1, "stop after close");
        }
        try {
            consumer.getProgramInfo(program);
            TestStateMachine.exit(1, "getProgramInfo after close");
        }
        catch (IllegalStateException e) {
            System.out.println(e);
        }
        catch (Exception e) {
            e.printStackTrace();
            TestStateMachine.exit(1, "getProgramInfo after close");
        }
    }

    public static void main(String[] args) {
        LocalConsumer consumer = new LocalConsumer();
        consumer.addConsumerListener((ConsumerListener)new ConsumerAdapter((Consumer)consumer){
            final /* synthetic */ Consumer val$consumer;
            {
                this.val$consumer = consumer;
            }

            public void consumerStarted(ConsumerEvent e) {
                System.out.println("consumerStarted, running: " + this.val$consumer.isRunning());
                TestStateMachine.afterGo(this.val$consumer, program);
            }

            public void consumerStopped(ConsumerEvent e) {
                System.out.println("consumerStopped, running: " + this.val$consumer.isRunning());
            }
        });
        try {
            TestStateMachine.beforeOpen((Consumer)consumer);
            consumer.open(new Consumer.OpenFlag[0]);
            TestStateMachine.beforeCompile((Consumer)consumer);
            program = consumer.compile("syscall:::entry { @[execname] = count(); } tick-101ms { printa(@); }", new String[0]);
            TestStateMachine.beforeEnable((Consumer)consumer);
            consumer.enable();
            TestStateMachine.beforeGo((Consumer)consumer);
            System.out.println("before go, running: " + consumer.isRunning());
            consumer.go();
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                TestStateMachine.exit(1);
            }
            consumer.stop();
            System.out.println("after stop, running: " + consumer.isRunning());
            TestStateMachine.afterStop((Consumer)consumer, program);
            consumer.close();
            TestStateMachine.afterClose((Consumer)consumer, program);
        }
        catch (DTraceException e) {
            e.printStackTrace();
            TestStateMachine.exit(1);
        }
    }
}

