/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Collections;
import org.opensolaris.os.dtrace.Consumer;
import org.opensolaris.os.dtrace.ConsumerAdapter;
import org.opensolaris.os.dtrace.ConsumerEvent;
import org.opensolaris.os.dtrace.ConsumerListener;
import org.opensolaris.os.dtrace.DTraceException;
import org.opensolaris.os.dtrace.DataEvent;
import org.opensolaris.os.dtrace.LocalConsumer;
import org.opensolaris.os.dtrace.ProbeData;
import org.opensolaris.os.dtrace.ProbeDescription;

public class TestProbeData {
    public static final String PROGRAM = "pid$target::fN:entry\n{\n        tracemem(copyin(arg1, 6), 6);\n        ufunc(arg0);\n        trace((int)arg2);\n}pid$target::fN2:entry\n{\n        tracemem(copyin(arg1, 6), 6);\n        ufunc(arg0);\n        trace((int)arg2);\n}";

    static String getString(ProbeData p) {
        StringBuilder buf = new StringBuilder();
        buf.append("[probe ");
        buf.append(p.getEnabledProbeID());
        buf.append(' ');
        ProbeDescription d = p.getEnabledProbeDescription();
        buf.append("pid$target");
        buf.append(':');
        buf.append(d.getModule());
        buf.append(':');
        buf.append(d.getFunction());
        buf.append(':');
        buf.append(d.getName());
        buf.append(' ');
        buf.append(p.getRecords());
        buf.append("]");
        return buf.toString();
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.err.println("usage: java TestProbedata <command>");
            System.exit(2);
        }
        String command = args[0];
        LocalConsumer consumer = new LocalConsumer();
        final ArrayList list = new ArrayList();
        consumer.addConsumerListener((ConsumerListener)new ConsumerAdapter((Consumer)consumer){
            final /* synthetic */ Consumer val$consumer;
            {
                this.val$consumer = consumer;
            }

            public void dataReceived(DataEvent e) {
                list.add(e.getProbeData());
            }

            public void consumerStopped(ConsumerEvent e) {
                Collections.sort(list);
                for (ProbeData p : list) {
                    System.out.println(TestProbeData.getString(p));
                    System.out.println();
                }
                this.val$consumer.close();
            }
        });
        try {
            consumer.open(new Consumer.OpenFlag[0]);
            consumer.createProcess(command);
            consumer.compile(PROGRAM, new String[0]);
            consumer.enable();
            consumer.go();
        }
        catch (DTraceException e) {
            e.printStackTrace();
        }
    }
}

