/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.opensolaris.os.dtrace.Consumer;
import org.opensolaris.os.dtrace.ConsumerAdapter;
import org.opensolaris.os.dtrace.ConsumerEvent;
import org.opensolaris.os.dtrace.ConsumerListener;
import org.opensolaris.os.dtrace.DTraceException;
import org.opensolaris.os.dtrace.DataEvent;
import org.opensolaris.os.dtrace.ExitRecord;
import org.opensolaris.os.dtrace.LocalConsumer;
import org.opensolaris.os.dtrace.PrintaRecord;
import org.opensolaris.os.dtrace.ProbeData;
import org.opensolaris.os.dtrace.Record;
import org.opensolaris.os.dtrace.ValueRecord;

public class TestMultiAggPrinta {
    static int exitStatus;

    static String printaRecordString(PrintaRecord rec) {
        StringBuffer buf = new StringBuffer();
        buf.append(PrintaRecord.class.getName());
        buf.append("[aggregations = ");
        buf.append(rec.getAggregations());
        buf.append(", formattedStrings = ");
        buf.append(rec.getFormattedStrings());
        buf.append(", tuples = ");
        buf.append(rec.getTuples());
        buf.append(", output = ");
        buf.append(rec.getOutput());
        buf.append(']');
        return buf.toString();
    }

    static String probeDataString(ProbeData data) {
        StringBuffer buf = new StringBuffer();
        buf.append(ProbeData.class.getName());
        buf.append("[epid = ");
        buf.append(data.getEnabledProbeID());
        buf.append(", enabledProbeDescription = ");
        buf.append(data.getEnabledProbeDescription());
        buf.append(", flow = ");
        buf.append(data.getFlow());
        buf.append(", records = ");
        List records = data.getRecords();
        buf.append('[');
        for (int i = 0; i < records.size(); ++i) {
            Record record;
            if (i > 0) {
                buf.append(", ");
            }
            if ((record = (Record)records.get(i)) instanceof ValueRecord) {
                Object value = ((ValueRecord)record).getValue();
                if (value instanceof String) {
                    buf.append("\"");
                    buf.append((String)value);
                    buf.append("\"");
                    continue;
                }
                buf.append(record);
                continue;
            }
            if (record instanceof PrintaRecord) {
                PrintaRecord printa = (PrintaRecord)record;
                buf.append(TestMultiAggPrinta.printaRecordString(printa));
                continue;
            }
            buf.append(record);
        }
        buf.append(']');
        return buf.toString();
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.err.println("usage: java TestMultiAggPrinta <script>");
            System.exit(2);
        }
        LocalConsumer consumer = new LocalConsumer();
        consumer.addConsumerListener((ConsumerListener)new ConsumerAdapter((Consumer)consumer){
            final /* synthetic */ Consumer val$consumer;
            {
                this.val$consumer = consumer;
            }

            public void dataReceived(DataEvent e) {
                ProbeData data = e.getProbeData();
                List records = data.getRecords();
                for (Record r : records) {
                    if (!(r instanceof ExitRecord)) continue;
                    ExitRecord exitRecord = (ExitRecord)r;
                    exitStatus = exitRecord.getStatus();
                }
                System.out.println(TestMultiAggPrinta.probeDataString(e.getProbeData()));
            }

            public void consumerStopped(ConsumerEvent e) {
                this.val$consumer.close();
                System.exit(exitStatus);
            }
        });
        File file = new File(args[0]);
        try {
            consumer.open(new Consumer.OpenFlag[0]);
            consumer.compile(file, new String[0]);
            consumer.enable();
            consumer.go();
        }
        catch (DTraceException e) {
            e.printStackTrace();
            System.exit(1);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }
}

