/*
 * Decompiled with CFR 0.152.
 */
import java.util.HashMap;
import java.util.HashSet;
import org.opensolaris.os.dtrace.Aggregate;
import org.opensolaris.os.dtrace.Aggregation;
import org.opensolaris.os.dtrace.AggregationRecord;
import org.opensolaris.os.dtrace.Consumer;
import org.opensolaris.os.dtrace.ConsumerAdapter;
import org.opensolaris.os.dtrace.ConsumerEvent;
import org.opensolaris.os.dtrace.ConsumerListener;
import org.opensolaris.os.dtrace.DTraceException;
import org.opensolaris.os.dtrace.LocalConsumer;
import org.opensolaris.os.dtrace.Option;
import org.opensolaris.os.dtrace.Tuple;

public class TestGetAggregate {
    static final String programString = "profile:::tick-50ms{        @ = count();        @a = count();}";
    static final String ANONYMOUS_AGGREGATION = "";
    static final int TICK = 50;
    static final int EXPECTED_TICKS = 3;
    static final int INTERVALS = 4;
    static Integer includedStatus;
    static Integer clearedStatus;

    static void testIncluded(Consumer consumer, String ... aggregationNames) throws DTraceException, InterruptedException {
        Aggregate aggregate;
        HashSet<String> included = new HashSet<String>();
        int n = 1;
        for (String name : aggregationNames) {
            included.add(name);
        }
        do {
            Thread.sleep(50L);
        } while ((aggregate = consumer.getAggregate(included, null)).asMap().isEmpty() && n++ < 20);
        for (String name : included) {
            if (aggregate.getAggregation(name) != null) continue;
            throw new IllegalStateException("@" + name + " was explicitly included but did not appear " + "in the aggregate");
        }
        for (Aggregation a : aggregate.getAggregations()) {
            if (included.contains(a.getName())) continue;
            throw new IllegalStateException("@" + a.getName() + " was not explicitly included but appeared " + "in the aggregate anyway");
        }
        if (!consumer.isRunning()) {
            throw new IllegalStateException("consumer exited");
        }
    }

    static void testCleared(Consumer consumer, String ... aggregationNames) throws DTraceException, InterruptedException {
        long value;
        AggregationRecord rec;
        Aggregate aggregate;
        int n = 1;
        HashMap<String, Long> firstValues = new HashMap<String, Long>();
        HashSet<String> cleared = new HashSet<String>();
        for (String name : aggregationNames) {
            cleared.add(name);
        }
        do {
            Thread.sleep(50L);
        } while ((aggregate = consumer.getAggregate(null, cleared)).asMap().isEmpty() && n++ < 20);
        n = 1;
        do {
            Thread.sleep(150L);
            aggregate = consumer.getAggregate(null, cleared);
            for (Aggregation a : aggregate.getAggregations()) {
                if (firstValues.containsKey(a.getName())) continue;
                rec = a.getRecord(Tuple.EMPTY);
                value = rec.getValue().getValue().longValue();
                firstValues.put(a.getName(), value);
            }
        } while (consumer.isRunning() && n++ < 4);
        for (Aggregation a : aggregate.getAggregations()) {
            rec = a.getRecord(Tuple.EMPTY);
            value = rec.getValue().getValue().longValue();
            Long firstValue = (Long)firstValues.get(a.getName());
            if (cleared.contains(a.getName())) {
                if (value <= firstValue * 2L) continue;
                throw new IllegalStateException("@" + a.getName() + " should have " + "been cleared but instead grew from " + firstValue + " to " + value);
            }
            if (value >= firstValue * 2L) continue;
            throw new IllegalStateException("@" + a.getName() + " should have " + "accumulated a running total but " + "instead went from " + firstValue + " to " + value);
        }
        if (!consumer.isRunning()) {
            throw new IllegalStateException("consumer exited");
        }
    }

    static void startIncludedTest() {
        LocalConsumer consumer = new LocalConsumer();
        consumer.addConsumerListener((ConsumerListener)new ConsumerAdapter((Consumer)consumer){
            final /* synthetic */ Consumer val$consumer;
            {
                this.val$consumer = consumer;
            }

            public void consumerStarted(ConsumerEvent e) {
                new Thread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            TestGetAggregate.testIncluded(val$consumer, TestGetAggregate.ANONYMOUS_AGGREGATION);
                            includedStatus = 0;
                        }
                        catch (Exception e) {
                            includedStatus = 1;
                            e.printStackTrace();
                        }
                        finally {
                            val$consumer.abort();
                        }
                    }
                }).start();
            }
        });
        try {
            consumer.open(new Consumer.OpenFlag[0]);
            consumer.setOption("aggrate", Option.millis((int)50));
            consumer.compile(programString, new String[0]);
            consumer.enable();
            consumer.go();
        }
        catch (Exception e) {
            includedStatus = 1;
            e.printStackTrace();
        }
    }

    static void startClearedTest() {
        LocalConsumer consumer = new LocalConsumer();
        consumer.addConsumerListener((ConsumerListener)new ConsumerAdapter((Consumer)consumer){
            final /* synthetic */ Consumer val$consumer;
            {
                this.val$consumer = consumer;
            }

            public void consumerStarted(ConsumerEvent e) {
                new Thread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            TestGetAggregate.testCleared(val$consumer, TestGetAggregate.ANONYMOUS_AGGREGATION);
                            clearedStatus = 0;
                        }
                        catch (Exception e) {
                            clearedStatus = 1;
                            e.printStackTrace();
                        }
                        finally {
                            val$consumer.abort();
                        }
                    }
                }).start();
            }
        });
        try {
            consumer.open(new Consumer.OpenFlag[0]);
            consumer.setOption("aggrate", Option.millis((int)50));
            consumer.compile(programString, new String[0]);
            consumer.enable();
            consumer.go();
        }
        catch (Exception e) {
            clearedStatus = 1;
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        TestGetAggregate.startIncludedTest();
        do {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } while (includedStatus == null);
        TestGetAggregate.startClearedTest();
        do {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } while (clearedStatus == null);
        if (includedStatus != 0 || clearedStatus != 0) {
            System.out.println("Failure");
            System.exit(1);
        }
        System.out.println("Success");
    }
}

