/*
 * Decompiled with CFR 0.152.
 */
import org.opensolaris.os.dtrace.Aggregate;
import org.opensolaris.os.dtrace.Aggregation;
import org.opensolaris.os.dtrace.Consumer;
import org.opensolaris.os.dtrace.LocalConsumer;
import org.opensolaris.os.dtrace.Tuple;

public class TestFunctionLookup {
    static final String kernelLookupProgram = "sdt:::callout-start { @[((callout_t *)arg0)->c_func] = count(); }";
    static final String userLookupProgram = "pid$target::f2:entry { @[arg0] = count(); }";

    public static void main(String[] args) {
        if (args.length != 1) {
            System.err.println("usage: java TestFunctionLookup <command>");
            System.exit(1);
        }
        String cmd = args[0];
        LocalConsumer consumer = new LocalConsumer();
        try {
            consumer.open(new Consumer.OpenFlag[0]);
            consumer.compile(kernelLookupProgram, new String[0]);
            consumer.enable();
            consumer.go();
            boolean done = false;
            for (int i = 0; i < 20 && !done; ++i) {
                Thread.sleep(100L);
                Aggregate a = consumer.getAggregate();
                for (Aggregation agg : a.getAggregations()) {
                    for (Tuple tuple : agg.asMap().keySet()) {
                        String f;
                        Number address = (Number)tuple.get(0).getValue();
                        if (address instanceof Integer) {
                            int addr = (Integer)address;
                            f = consumer.lookupKernelFunction(addr);
                        } else {
                            long addr = (Long)address;
                            f = consumer.lookupKernelFunction(addr);
                        }
                        if (!f.equals("genunix`cv_wakeup")) continue;
                        System.out.println(f);
                        done = true;
                    }
                }
            }
            consumer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        consumer = new LocalConsumer();
        try {
            consumer.open(new Consumer.OpenFlag[0]);
            int pid = consumer.createProcess(cmd);
            consumer.compile(userLookupProgram, new String[0]);
            consumer.enable();
            consumer.go();
            Thread.sleep(500L);
            Aggregate a = consumer.getAggregate();
            for (Aggregation agg : a.getAggregations()) {
                for (Tuple tuple : agg.asMap().keySet()) {
                    String f;
                    Number address = (Number)tuple.get(0).getValue();
                    if (address instanceof Integer) {
                        int addr = (Integer)address;
                        f = consumer.lookupUserFunction(pid, addr);
                    } else {
                        long addr = (Long)address;
                        f = consumer.lookupUserFunction(pid, addr);
                    }
                    System.out.println(f);
                }
            }
            consumer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }
}

