/*
 * Decompiled with CFR 0.152.
 */
import java.util.Collections;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.opensolaris.os.dtrace.Consumer;
import org.opensolaris.os.dtrace.ConsumerAdapter;
import org.opensolaris.os.dtrace.ConsumerEvent;
import org.opensolaris.os.dtrace.ConsumerException;
import org.opensolaris.os.dtrace.ConsumerListener;
import org.opensolaris.os.dtrace.DTraceException;
import org.opensolaris.os.dtrace.Drop;
import org.opensolaris.os.dtrace.DropEvent;
import org.opensolaris.os.dtrace.ExceptionHandler;
import org.opensolaris.os.dtrace.LocalConsumer;
import org.opensolaris.os.dtrace.Option;

public class TestDrop {
    static final String PROGRAM = "fbt:genunix::entry { @[execname, pid] = count(); }";
    static AtomicLong consumerThreadID = new AtomicLong();
    static AtomicLong getAggregateThreadID = new AtomicLong();
    static AtomicBoolean done = new AtomicBoolean();
    static int seconds;

    private static void startTimer() {
        if (seconds <= 0) {
            return;
        }
        final Timer timer = new Timer();
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                done.set(true);
                timer.cancel();
            }
        }, (long)seconds * 1000L);
    }

    private static void sampleAggregate(Consumer consumer) throws DTraceException {
        while (consumer.isRunning() && !done.get()) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            consumer.getAggregate(Collections.emptySet());
        }
    }

    private static void startAggregateThread(final Consumer consumer) {
        Runnable aggregateSampler = new Runnable(){

            @Override
            public void run() {
                Thread t = Thread.currentThread();
                getAggregateThreadID.set(t.getId());
                Throwable x = null;
                try {
                    TestDrop.sampleAggregate(consumer);
                }
                catch (Throwable e) {
                    x = e;
                }
                if (Thread.holdsLock(LocalConsumer.class)) {
                    if (x != null) {
                        x.printStackTrace();
                    }
                    System.out.println("Lock held");
                    System.exit(1);
                } else {
                    System.out.println("Lock released");
                    consumer.close();
                }
            }
        };
        Thread t = new Thread(aggregateSampler, "Aggregate Sampler");
        t.start();
    }

    static void usage() {
        System.err.println("usage: java TestDrop [ seconds ]");
        System.exit(2);
    }

    public static void main(String[] args) {
        if (args.length == 1) {
            try {
                seconds = Integer.parseInt(args[0]);
            }
            catch (NumberFormatException e) {
                TestDrop.usage();
            }
        } else if (args.length > 1) {
            TestDrop.usage();
        }
        LocalConsumer consumer = new LocalConsumer(){

            protected Thread createThread() {
                Runnable worker = new Runnable(){

                    @Override
                    public void run() {
                        Thread t = Thread.currentThread();
                        consumerThreadID.set(t.getId());
                        this.work();
                    }
                };
                Thread t = new Thread(worker);
                return t;
            }
        };
        consumer.addConsumerListener((ConsumerListener)new ConsumerAdapter((Consumer)consumer){
            final /* synthetic */ Consumer val$consumer;
            {
                this.val$consumer = consumer;
            }

            public void consumerStarted(ConsumerEvent e) {
                TestDrop.startAggregateThread(this.val$consumer);
                TestDrop.startTimer();
            }

            public void dataDropped(DropEvent e) throws ConsumerException {
                Thread t = Thread.currentThread();
                if (t.getId() == getAggregateThreadID.get()) {
                    Drop drop = e.getDrop();
                    throw new ConsumerException(drop.getDefaultMessage(), (Object)drop);
                }
            }
        });
        try {
            consumer.open(new Consumer.OpenFlag[0]);
            consumer.setOption("aggsize", Option.kb((int)1));
            consumer.setOption("aggrate", Option.millis((int)101));
            consumer.compile(PROGRAM, new String[0]);
            consumer.enable();
            consumer.go(new ExceptionHandler(){

                public void handleException(Throwable e) {
                    e.printStackTrace();
                }
            });
        }
        catch (DTraceException e) {
            e.printStackTrace();
        }
    }
}

