/*
 * Decompiled with CFR 0.152.
 */
import java.beans.ExceptionListener;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import org.opensolaris.os.dtrace.Aggregate;
import org.opensolaris.os.dtrace.Aggregation;
import org.opensolaris.os.dtrace.AggregationRecord;
import org.opensolaris.os.dtrace.AggregationValue;
import org.opensolaris.os.dtrace.AvgValue;
import org.opensolaris.os.dtrace.Consumer;
import org.opensolaris.os.dtrace.CountValue;
import org.opensolaris.os.dtrace.DTraceException;
import org.opensolaris.os.dtrace.Distribution;
import org.opensolaris.os.dtrace.Drop;
import org.opensolaris.os.dtrace.Error;
import org.opensolaris.os.dtrace.ExitRecord;
import org.opensolaris.os.dtrace.Flow;
import org.opensolaris.os.dtrace.InterfaceAttributes;
import org.opensolaris.os.dtrace.KernelStackRecord;
import org.opensolaris.os.dtrace.KernelSymbolRecord;
import org.opensolaris.os.dtrace.LinearDistribution;
import org.opensolaris.os.dtrace.LocalConsumer;
import org.opensolaris.os.dtrace.LogDistribution;
import org.opensolaris.os.dtrace.LogLinearDistribution;
import org.opensolaris.os.dtrace.MaxValue;
import org.opensolaris.os.dtrace.MinValue;
import org.opensolaris.os.dtrace.Option;
import org.opensolaris.os.dtrace.PrintaRecord;
import org.opensolaris.os.dtrace.PrintfRecord;
import org.opensolaris.os.dtrace.Probe;
import org.opensolaris.os.dtrace.ProbeData;
import org.opensolaris.os.dtrace.ProbeDescription;
import org.opensolaris.os.dtrace.ProbeInfo;
import org.opensolaris.os.dtrace.ProcessState;
import org.opensolaris.os.dtrace.Program;
import org.opensolaris.os.dtrace.ProgramInfo;
import org.opensolaris.os.dtrace.ScalarRecord;
import org.opensolaris.os.dtrace.StackFrame;
import org.opensolaris.os.dtrace.StddevValue;
import org.opensolaris.os.dtrace.SumValue;
import org.opensolaris.os.dtrace.Tuple;
import org.opensolaris.os.dtrace.UserStackRecord;
import org.opensolaris.os.dtrace.UserSymbolRecord;
import org.opensolaris.os.dtrace.ValueRecord;

public class TestBean {
    public static final String[] TESTS = new String[]{"ExitRecord", "AggregationRecord", "Aggregation", "Tuple", "ScalarRecord", "KernelStackRecord", "LogDistribution", "LinearDistribution", "LogLinearDistribution", "Option", "ProcessState", "ProbeDescription", "PrintaRecord", "PrintfRecord", "ProbeData", "Aggregate", "UserStackRecord", "AvgValue", "CountValue", "SumValue", "MinValue", "MaxValue", "Error", "Drop", "InterfaceAttributes", "ProgramInfo", "ProbeInfo", "Probe", "Flow", "KernelSymbolRecord", "UserSymbolRecord", "UserSymbolRecord$Value", "Program", "Program$File", "StddevValue"};
    static File file;

    static void exit(int status) {
        System.out.flush();
        System.err.flush();
        System.exit(status);
    }

    public static XMLEncoder getXMLEncoder(File file) {
        XMLEncoder encoder = null;
        try {
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
            encoder = new XMLEncoder(out);
        }
        catch (Exception e) {
            e.printStackTrace();
            TestBean.exit(1);
        }
        return encoder;
    }

    public static XMLDecoder getXMLDecoder(File file) {
        return TestBean.getXMLDecoder(file, null);
    }

    public static XMLDecoder getXMLDecoder(File file, ExceptionListener exceptionListener) {
        XMLDecoder decoder = null;
        try {
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
            decoder = new XMLDecoder(in, null, exceptionListener);
        }
        catch (Exception e) {
            e.printStackTrace();
            TestBean.exit(1);
        }
        return decoder;
    }

    public static ExitRecord getExitRecord() {
        ExitRecord r = new ExitRecord(1);
        return r;
    }

    public static AggregationRecord getAggregationRecord() {
        Tuple tuple = TestBean.getTuple();
        CountValue value = new CountValue(7L);
        AggregationRecord r = new AggregationRecord(tuple, (AggregationValue)value);
        return r;
    }

    public static Aggregation getAggregation() {
        ArrayList<AggregationRecord> list = new ArrayList<AggregationRecord>();
        AggregationRecord r = TestBean.getAggregationRecord();
        list.add(r);
        ScalarRecord v1 = new ScalarRecord((Object)new byte[]{1, 2, 3}, 3);
        ScalarRecord v2 = new ScalarRecord((Object)"shebang!", 256);
        Tuple tuple = new Tuple(new ValueRecord[]{v1, v2});
        LinearDistribution value = TestBean.getLinearDistribution();
        r = new AggregationRecord(tuple, (AggregationValue)value);
        list.add(r);
        Aggregation a = new Aggregation("counts", 2L, list);
        return a;
    }

    public static Tuple getTuple() {
        ScalarRecord r1 = new ScalarRecord((Object)"cat", 256);
        ScalarRecord r2 = new ScalarRecord((Object)new Integer(9), 2);
        KernelStackRecord r3 = new KernelStackRecord(new StackFrame[]{new StackFrame("has"), new StackFrame("nine"), new StackFrame("lives")}, new byte[]{0, 1, 2});
        ScalarRecord r4 = new ScalarRecord((Object)new byte[]{1, 2, 3}, 3);
        Tuple tuple = new Tuple(new ValueRecord[]{r1, r2, r3, r4});
        return tuple;
    }

    public static ScalarRecord getScalarRecord() {
        byte[] v = new byte[]{1, 2, 3};
        ScalarRecord r = new ScalarRecord((Object)v, 3);
        return r;
    }

    public static KernelStackRecord getKernelStackRecord() {
        StackFrame[] stackFrames = new StackFrame[]{new StackFrame("Frame 1"), new StackFrame("Frame 2"), new StackFrame("Frame 3")};
        KernelStackRecord r = new KernelStackRecord(stackFrames, new byte[]{0, 1, 2});
        return r;
    }

    public static LogDistribution getLogDistribution() {
        ArrayList<Distribution.Bucket> buckets = new ArrayList<Distribution.Bucket>();
        int n = 0;
        long base = 0L;
        for (long i = -62L; i <= 62L; ++i) {
            long upperBound;
            Distribution.Bucket bucket;
            if (i == 0L) {
                bucket = new Distribution.Bucket(-1L, -1L, (long)n++);
                buckets.add(bucket);
                bucket = new Distribution.Bucket(0L, 0L, (long)n++);
                buckets.add(bucket);
                bucket = new Distribution.Bucket(1L, 1L, (long)n++);
                buckets.add(bucket);
                continue;
            }
            long sign = i < 0L ? -1L : 1L;
            long power = sign * i;
            long nextSign = i + 1L < 0L ? -1L : 1L;
            long nextPower = nextSign * (i + 1L);
            long lowerBound = sign * (long)Math.pow(2.0, power);
            long l = upperBound = nextPower == 0L ? -2L : nextSign * (long)Math.pow(2.0, nextPower) - 1L;
            if (upperBound > 0L && upperBound * 2L < 0L) {
                upperBound = Long.MAX_VALUE;
            }
            bucket = new Distribution.Bucket(lowerBound, upperBound, (long)n++);
            buckets.add(bucket);
        }
        LogDistribution d = new LogDistribution(buckets);
        return d;
    }

    public static LinearDistribution getLinearDistribution() {
        ArrayList<Distribution.Bucket> buckets = new ArrayList<Distribution.Bucket>();
        int n = 10;
        int base = 1;
        int step = 10;
        Distribution.Bucket bucket = new Distribution.Bucket(Long.MIN_VALUE, (long)(base - 1), 0L);
        buckets.add(bucket);
        for (int i = base; i < n * step; i += step) {
            bucket = new Distribution.Bucket((long)i, (long)(i + (step - 1)), (long)((i - 1) / step));
            buckets.add(bucket);
        }
        bucket = new Distribution.Bucket((long)(n * step + 1), Long.MAX_VALUE, 0L);
        buckets.add(bucket);
        LinearDistribution d = new LinearDistribution((long)base, (long)step, buckets);
        return d;
    }

    public static LogLinearDistribution getLogLinearDistribution() {
        long step;
        long low = 0L;
        long high = 6L;
        long factor = 2L;
        long nsteps = 2L;
        int value = 1;
        ArrayList<Distribution.Bucket> buckets = new ArrayList<Distribution.Bucket>();
        int order = 0;
        while ((long)order < low) {
            value = (int)((long)value * factor);
            ++order;
        }
        Distribution.Bucket bucket = new Distribution.Bucket(Long.MIN_VALUE, (long)(value - 1), 0L);
        buckets.add(bucket);
        long next = (long)value * factor;
        long l = step = next > nsteps ? next / nsteps : 1L;
        while ((long)order <= high) {
            bucket = new Distribution.Bucket((long)value, (long)value + step - 1L, 5L);
            buckets.add(bucket);
            if ((long)(value = (int)((long)value + step)) != next) continue;
            next = (long)value * factor;
            step = next > nsteps ? next / nsteps : 1L;
            ++order;
        }
        bucket = new Distribution.Bucket((long)value, Long.MAX_VALUE, 0L);
        buckets.add(bucket);
        LogLinearDistribution d = new LogLinearDistribution(factor, low, high, nsteps, 0L, buckets);
        return d;
    }

    public static Option getOption() {
        Option option = new Option("aggrate", "1s");
        return option;
    }

    public static ProcessState getProcessState() {
        ProcessState p = new ProcessState(123456, "UNDEAD", 3, "SIGSTOP", Integer.valueOf(-2), "Process stopped on dime");
        return p;
    }

    public static ProbeDescription getProbeDescription() {
        ProbeDescription d = new ProbeDescription(256, "syscall", null, "malloc", "entry");
        return d;
    }

    public static PrintaRecord getPrintaRecord() {
        ArrayList<Aggregation> aggregations = new ArrayList<Aggregation>();
        Aggregation a = TestBean.getAggregation();
        aggregations.add(a);
        aggregations.add(a);
        HashMap<Tuple, String> formattedOutput = new HashMap<Tuple, String>();
        for (Tuple t : a.asMap().keySet()) {
            formattedOutput.put(t, "cat");
        }
        ArrayList<Tuple> tuples = new ArrayList<Tuple>();
        for (Tuple t : a.asMap().keySet()) {
            tuples.add(t);
        }
        Collections.sort(tuples);
        PrintaRecord r = new PrintaRecord(1234567890L, aggregations, formattedOutput, tuples, "Yes, this is the formatted printa() output");
        return r;
    }

    public static PrintfRecord getPrintfRecord() {
        ArrayList<ScalarRecord> list = new ArrayList<ScalarRecord>();
        ScalarRecord v1 = TestBean.getScalarRecord();
        ScalarRecord v2 = new ScalarRecord((Object)new Integer(7), 4);
        list.add(v1);
        list.add(v2);
        PrintfRecord r = new PrintfRecord(list, "long formatted string");
        return r;
    }

    public static ProbeData getProbeData() {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(TestBean.getPrintaRecord());
        list.add(TestBean.getPrintfRecord());
        list.add(TestBean.getScalarRecord());
        list.add(TestBean.getUserSymbolRecord());
        list.add(TestBean.getUserStackRecord());
        list.add(TestBean.getExitRecord());
        ProbeData d = new ProbeData(7, 1, TestBean.getProbeDescription(), TestBean.getFlow(), list);
        return d;
    }

    public static Aggregate getAggregate() {
        ArrayList<Aggregation> list = new ArrayList<Aggregation>();
        list.add(TestBean.getAggregation());
        ArrayList<AggregationRecord> reclist = new ArrayList<AggregationRecord>();
        ScalarRecord v1 = new ScalarRecord((Object)"cat", 256);
        ScalarRecord v2 = new ScalarRecord((Object)"dog", 256);
        ScalarRecord v3 = new ScalarRecord((Object)"mouse", 256);
        ScalarRecord v4 = new ScalarRecord((Object)"mouse", 256);
        ScalarRecord v5 = new ScalarRecord((Object)new Byte(67), 1);
        ScalarRecord v6 = new ScalarRecord((Object)new Short(7), 2);
        Tuple tuple = new Tuple(new ValueRecord[]{v1, v2, v3, v4, v5, v6});
        CountValue value = TestBean.getCountValue();
        AggregationRecord r = new AggregationRecord(tuple, (AggregationValue)value);
        reclist.add(r);
        list.add(new Aggregation("times", 1L, reclist));
        Aggregate a = new Aggregate(1234567890L, list);
        return a;
    }

    public static UserStackRecord getUserStackRecord() {
        StackFrame[] frames = new StackFrame[]{new StackFrame("User Stack Frame 1"), new StackFrame("User Stack Frame 2"), new StackFrame("User Stack Frame 3")};
        UserStackRecord r = new UserStackRecord(123456, frames, new byte[]{0, 1, 2});
        return r;
    }

    public static AvgValue getAvgValue() {
        AvgValue v = new AvgValue(5L, 20L, 4L);
        return v;
    }

    public static CountValue getCountValue() {
        CountValue v = new CountValue(9L);
        return v;
    }

    public static MinValue getMinValue() {
        MinValue v = new MinValue(101L);
        return v;
    }

    public static MaxValue getMaxValue() {
        MaxValue v = new MaxValue(101L);
        return v;
    }

    public static SumValue getSumValue() {
        SumValue v = new SumValue(25L);
        return v;
    }

    public static Error getError() {
        ProbeDescription probe = TestBean.getProbeDescription();
        Error e = new Error(probe, 8, 3, 1, 20, "DTRACEFLT_BADALIGN", -1L, "error on enabled probe ID 8 (ID " + probe.getID() + ": " + probe + "): Bad alignment " + "(0x33ef) in action #1 at DIF offset 20");
        return e;
    }

    public static Drop getDrop() {
        Drop drop = new Drop(2, "SPECBUSY", 72L, 1041L, "Guess we dropped stuff all over the place.");
        return drop;
    }

    public static InterfaceAttributes getInterfaceAttributes() {
        InterfaceAttributes a = new InterfaceAttributes(InterfaceAttributes.Stability.UNSTABLE, InterfaceAttributes.Stability.EVOLVING, InterfaceAttributes.DependencyClass.ISA);
        return a;
    }

    public static ProgramInfo getProgramInfo() {
        ProgramInfo info = new ProgramInfo(TestBean.getInterfaceAttributes(), TestBean.getInterfaceAttributes(), 256);
        return info;
    }

    public static ProbeInfo getProbeInfo() {
        ProbeInfo info = new ProbeInfo(TestBean.getInterfaceAttributes(), TestBean.getInterfaceAttributes());
        return info;
    }

    public static Probe getProbe() {
        Probe p = new Probe(TestBean.getProbeDescription(), TestBean.getProbeInfo());
        return p;
    }

    public static Flow getFlow() {
        Flow f = new Flow(Flow.Kind.RETURN.name(), 3);
        return f;
    }

    public static KernelSymbolRecord getKernelSymbolRecord() {
        KernelSymbolRecord r = new KernelSymbolRecord("mod`func+0x4", -1L);
        return r;
    }

    public static UserSymbolRecord getUserSymbolRecord() {
        UserSymbolRecord r = new UserSymbolRecord(7, "mod`func+0x4", -1L);
        return r;
    }

    public static UserSymbolRecord.Value getUserSymbolRecord$Value() {
        UserSymbolRecord.Value v = new UserSymbolRecord.Value(7, -1L);
        return v;
    }

    public static Program getProgram() {
        Program p;
        String PROGRAM = "syscall:::entry { @[execname] = count(); }";
        LocalConsumer consumer = new LocalConsumer();
        try {
            consumer.open(new Consumer.OpenFlag[0]);
            p = consumer.compile("syscall:::entry { @[execname] = count(); }", new String[0]);
            consumer.close();
        }
        catch (DTraceException e) {
            e.printStackTrace();
            p = null;
        }
        return p;
    }

    public static Program.File getProgram$File() {
        Program p;
        String PROGRAM = "syscall:::entry { @[execname] = count(); }";
        LocalConsumer consumer = new LocalConsumer();
        try {
            FileOutputStream out = new FileOutputStream(file);
            ((OutputStream)out).write("syscall:::entry { @[execname] = count(); }".getBytes(), 0, "syscall:::entry { @[execname] = count(); }".length());
            out.flush();
            ((OutputStream)out).close();
            consumer.open(new Consumer.OpenFlag[0]);
            p = consumer.compile(file, new String[0]);
            consumer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            p = null;
        }
        return (Program.File)Program.File.class.cast(p);
    }

    public static StddevValue getStddevValue() {
        StddevValue v = new StddevValue(37L, 114L, 5L, Integer.toString(9544));
        return v;
    }

    static String getString(Object o) {
        String s;
        if (o instanceof ScalarRecord) {
            o = ((ScalarRecord)o).getValue();
        }
        if (o instanceof byte[]) {
            s = Arrays.toString((byte[])o);
        } else if (o instanceof Object[]) {
            s = Arrays.toString((Object[])o);
        } else {
            Class<?> c = o.getClass();
            try {
                Method m = c.getDeclaredMethod("toLogString", new Class[0]);
                s = (String)m.invoke(o, new Object[0]);
            }
            catch (Exception e) {
                s = o.toString();
            }
        }
        return s;
    }

    static void checkEquality(Object obj, Object newobj) {
        try {
            Method eq = obj.getClass().getDeclaredMethod("equals", Object.class);
            Boolean ret = (Boolean)eq.invoke(obj, newobj);
            if (!ret.booleanValue()) {
                System.err.println("serialization failed: " + obj.getClass().getName());
                TestBean.exit(1);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static void performSerializationTest(File file, String classname) throws IOException, ClassNotFoundException {
        String methodName = "get" + classname;
        Object obj = null;
        Object newobj = null;
        try {
            Method method = TestBean.class.getDeclaredMethod(methodName, new Class[0]);
            obj = method.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            TestBean.exit(1);
        }
        System.out.println(classname + ":");
        String serialized = TestBean.getString(obj);
        System.out.println("  serialized: " + serialized);
        FileOutputStream fos = new FileOutputStream(file);
        ObjectOutputStream out = new ObjectOutputStream(fos);
        out.writeObject(obj);
        out.close();
        FileInputStream fis = new FileInputStream(file);
        ObjectInputStream in = new ObjectInputStream(fis);
        newobj = in.readObject();
        in.close();
        String deserialized = TestBean.getString(newobj);
        System.out.println("  deserialized: " + deserialized);
        if (!serialized.equals(deserialized)) {
            System.err.println("serialization failed: " + classname);
            TestBean.exit(1);
        }
        TestBean.checkEquality(obj, newobj);
    }

    static void performBeanTest(File file, String classname) {
        String methodName = "get" + classname;
        Object obj = null;
        Object newobj = null;
        try {
            Method method = TestBean.class.getDeclaredMethod(methodName, new Class[0]);
            obj = method.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            TestBean.exit(1);
        }
        Class<?> c = obj.getClass();
        if (c.getConstructors().length == 0) {
            return;
        }
        System.out.println(classname + ":");
        XMLEncoder encoder = TestBean.getXMLEncoder(file);
        String encoded = TestBean.getString(obj);
        System.out.println("  encoded: " + encoded);
        encoder.writeObject(obj);
        encoder.close();
        XMLDecoder decoder = TestBean.getXMLDecoder(file);
        newobj = decoder.readObject();
        String decoded = TestBean.getString(newobj);
        System.out.println("  decoded: " + decoded);
        decoder.close();
        if (!encoded.equals(decoded)) {
            System.err.println("bean persistence failed: " + classname);
            TestBean.exit(1);
        }
        TestBean.checkEquality(obj, newobj);
    }

    public static void main(String[] args) {
        String[] stringArray;
        if (args.length != 1 && args.length != 2) {
            System.err.println("usage: java TestBean < filename > [ < classname > ]");
            TestBean.exit(1);
        }
        String filename = args[0];
        String classname = null;
        if (args.length >= 2) {
            classname = args[1];
        }
        file = new File(filename);
        try {
            if (!file.canRead()) {
                try {
                    file.createNewFile();
                }
                catch (Exception e) {
                    System.err.println("failed to create " + filename);
                    TestBean.exit(1);
                }
            }
        }
        catch (SecurityException e) {
            System.err.println("failed to open " + filename);
            TestBean.exit(1);
        }
        if (classname == null) {
            stringArray = TESTS;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = classname;
        }
        String[] tests = stringArray;
        try {
            for (int i = 0; i < tests.length; ++i) {
                TestBean.performSerializationTest(file, tests[i]);
                TestBean.performBeanTest(file, tests[i]);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            TestBean.exit(1);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            TestBean.exit(1);
        }
    }
}

